-- BA Pack 2 [Millennium]
-- Character Voice Tables

-- ================================================================
-- Example
-- ================================================================
-- local VT_CHARNAME = {
--   [CHAR_SOUND_OKEY_DOKEY] = 'CharStartGame.ogg',                                       -- Starting game
--   [CHAR_SOUND_LETS_A_GO] = 'CharStartLevel.ogg',                                       -- Starting level
--   [CHAR_SOUND_GAME_OVER] = 'CharGameOver.ogg',                                         -- Game Overed
--   [CHAR_SOUND_PUNCH_YAH] = 'CharPunch1.ogg',                                           -- Punch 1
--   [CHAR_SOUND_PUNCH_WAH] = 'CharPunch2.ogg',                                           -- Punch 2
--   [CHAR_SOUND_PUNCH_HOO] = 'CharPunch3.ogg',                                           -- Punch 3
--   [CHAR_SOUND_YAH_WAH_HOO] = { 'CharJump1.ogg', 'CharJump2.ogg', 'CharJump3.ogg' },    -- First Jump Sounds
--   [CHAR_SOUND_HOOHOO] = 'CharDoubleJump.ogg',                                          -- Second jump sound
--   [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'CharTripleJump1.ogg', 'CharTripleJump2.ogg' },   -- Triple jump sounds
--   [CHAR_SOUND_UH] = 'CharBonk.ogg',                                                    -- Soft wall bonk
--   [CHAR_SOUND_UH2] = 'CharLedgeGetUp.ogg',                                             -- Quick ledge get up
--   [CHAR_SOUND_UH2_2] = 'CharLongJumpLand.ogg',                                         -- Landing after long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Hard wall bonk
--   [CHAR_SOUND_OOOF] = 'CharBonk.ogg',                                                  -- Attacked in air
--   [CHAR_SOUND_OOOF2] = 'CharBonk.ogg',                                                 -- Land from hard bonk
--   [CHAR_SOUND_HAHA] = 'CharTripleJumpLand.ogg',                                        -- Landing triple jump
--   [CHAR_SOUND_HAHA_2] = 'CharWaterLanding.ogg',                                        -- Landing in water from big fall
--   [CHAR_SOUND_YAHOO] = 'CharLongJump.ogg',                                             -- Long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Long jump wall bonk
--   [CHAR_SOUND_WHOA] = 'CharGrabLedge.ogg',                                             -- Grabbing ledge
--   [CHAR_SOUND_EEUH] = 'CharClimbLedge.ogg',                                            -- Climbing over ledge
--   [CHAR_SOUND_WAAAOOOW] = 'CharFalling.ogg',                                           -- Falling a long distance
--   [CHAR_SOUND_TWIRL_BOUNCE] = 'CharFlowerBounce.ogg',                                  -- Bouncing off of a flower spring
--   [CHAR_SOUND_GROUND_POUND_WAH] = 'CharGroundPound.ogg',                               -- Ground Pound after startup
--   [CHAR_SOUND_WAH2] = 'CharThrow.ogg',                                                 -- Throwing something
--   [CHAR_SOUND_HRMM] = 'CharLift.ogg',                                                  -- Lifting something
--   [CHAR_SOUND_HERE_WE_GO] = 'CharGetStar.ogg',                                         -- Star get
--   [CHAR_SOUND_SO_LONGA_BOWSER] = 'CharThrowBowser.ogg',                                -- Throwing Bowser
--   --DAMAGE
--   [CHAR_SOUND_ATTACKED] = 'CharDamaged.ogg',                                           -- Damaged
--   [CHAR_SOUND_PANTING] = 'CharPanting.ogg',                                            -- Low health
--   [CHAR_SOUND_PANTING_COLD] = 'CharPanting.ogg',                                       -- Getting cold
--   [CHAR_SOUND_ON_FIRE] = 'CharBurned.ogg',                                             -- Burned
--   --SLEEP SOUNDS
--   [CHAR_SOUND_IMA_TIRED] = 'CharTired.ogg',                                            -- Mario feeling tired
--   [CHAR_SOUND_YAWNING] = 'CharYawn.ogg',                                               -- Mario yawning before he sits down to sleep
--   [CHAR_SOUND_SNORING1] = 'CharSnore.ogg',                                             -- Snore Inhale
--   [CHAR_SOUND_SNORING2] = 'CharExhale.ogg',                                            -- Exhale
--   [CHAR_SOUND_SNORING3] = 'CharSleepTalk.ogg',                                         -- Sleep talking / mumbling
--   --COUGHING (USED IN THE GAS MAZE)
--   [CHAR_SOUND_COUGHING1] = 'CharCough1.ogg',                                           -- Cough take 1
--   [CHAR_SOUND_COUGHING2] = 'CharCough2.ogg',                                           -- Cough take 2
--   [CHAR_SOUND_COUGHING3] = 'CharCough3.ogg',                                           -- Cough take 3
--   --DEATH
--   [CHAR_SOUND_DYING] = 'CharDying.ogg',                                                -- Dying from damage
--   [CHAR_SOUND_DROWNING] = 'CharDrowning.ogg',                                          -- Running out of air underwater
--   [CHAR_SOUND_MAMA_MIA] = 'CharLeaveLevel.ogg'                                         -- Booted out of level
-- }

-- ================================================================
-- NPC Voices
-- Files are in Main
-- ================================================================

VT_NOVOICE = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_smrpg_hit1.mp3', 'sfx_smrpg_shell.mp3', 'sfx_smw_bossstun.mp3', 'sfx_ff6_fistattack.mp3', 'sfx_smw_bossstun.mp3', 'sfx_mmx_hurt.mp3' },
  [CHAR_SOUND_DOH] = 'sfx_ml_bump.mp3',                                              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sfx_smb3_down.mp3', 'sfx_cv3_dead.mp3', 'sfx_earthbound_dead.mp3'},
  [CHAR_SOUND_HERE_WE_GO] = { 'sfx_alttp_item.mp3', 'sfx_smrpg_specialflower.mp3', 'sfx_earthbound_good.mp3', 'sfx_kirby_1up.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'sfx_smb3_levelselect.mp3' },                           -- Level Select
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                      -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'sfx_smw_jump.mp3' },                                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'sfx_pm64_what.mp3',                                           -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_drop.mp3',                                         -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sfx_ssb64_atk3.mp3' },                                 -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sfx_ssb64_atk2.mp3',                                     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sfx_ssb64_atk1.mp3',                                     -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_smrpg_fireball.mp3' },                       -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'sfx_ssb64_itemthrow.mp3' },                                 -- Throw Object
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                   -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                              -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sfx_ssb64_superjump.mp3' },                                -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sfx_ssb64_superjump.mp3' },                    -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sfx_smw_jump.mp3' },                                 -- 1st Jump(s)
}

-- ================================================================
-- Voice Tables
-- ================================================================
VT_MOMOI = {
  [CHAR_SOUND_ATTACKED] = { 'momoi_hurt1.mp3', 'momoi_hurt2.mp3', 'momoi_yurusenai.mp3' },
  [CHAR_SOUND_DOH] = { 'momoi_guo.mp3', 'momoi_hoh.mp3' },
  [CHAR_SOUND_DYING] = { 'momoi_mou.mp3', 'momoi_hurt3.mp3' },
  [CHAR_SOUND_EEUH] = { 'momoi_ledgegetup.mp3' },
  [CHAR_SOUND_GAME_OVER] = { 'momoi_kusoge.mp3' },
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'momoi_attack4.mp3' },
  [CHAR_SOUND_HAHA] = 'momoi_aha.mp3',
  [CHAR_SOUND_HAHA_2] = 'momoi_aha.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'momoi_star_get.mp3', 'momoi_star2.mp3' },
  [CHAR_SOUND_HOOHOO] = 'momoi_jump1.mp3',
  [CHAR_SOUND_HRMM] = 'momoi_yosh.mp3',
  [CHAR_SOUND_IMA_TIRED] = 'momoi_hmmm.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'momoi_LetsGo.mp3',
  [CHAR_SOUND_MAMA_MIA] = 'momoi_kusoge.mp3',
  [CHAR_SOUND_ON_FIRE] = { 'momoi_hurt1.mp3' },
  [CHAR_SOUND_OOOF] = 'momoi_eh1.mp3',
  [CHAR_SOUND_OOOF2] = 'momoi_hurt1.mp3',
  [CHAR_SOUND_PUNCH_HOO] = { 'momoi_attack7.mp3' },
  [CHAR_SOUND_PUNCH_WAH] = 'momoi_attack1.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'momoi_attack2.mp3',
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'momoi_throw_bowser1.mp3' },
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'momoi_aha.mp3' },
  [CHAR_SOUND_UH] = 'momoi_hoh.mp3',    -- Drop off Ledge
  [CHAR_SOUND_UH2] = { 'momoi_jump1.mp3' },
  [CHAR_SOUND_UH2_2] = 'momoi_guo.mp3', -- Landing after long jump
  [CHAR_SOUND_WAAAOOOW] = 'momoi_falling.mp3',
  [CHAR_SOUND_WAH2] = 'momoi_throw1.mp3',
  [CHAR_SOUND_WHOA] = { 'momoi_ledge_grab.mp3', 'momoi_hueh.mp3' }, -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'momoi_yah.mp3' },
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'momoi_yah.mp3' },
  [CHAR_SOUND_YAH_WAH_HOO] = { 'momoi_attack2.mp3', 'momoi_attack6.mp3', 'momoi_attack5.mp3' },
  [CHAR_SOUND_YAWNING] = 'momoi_yawn.mp3',
}

VT_MIDORI = {
  [CHAR_SOUND_ATTACKED] = { 'midori_hurt2.mp3', 'midori_kuh.mp3', 'midori_eh.mp3' },
  [CHAR_SOUND_DOH] = 'midori_ah2.mp3',
  [CHAR_SOUND_DYING] = { 'midori_kuyashi2.mp3', 'midori_hurt3.mp3' },
  [CHAR_SOUND_EEUH] = { 'midori_ledgegetup.mp3', },
  --[CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'midori_attack4.mp3', 'midori_attack1.mp3', },
  [CHAR_SOUND_HAHA] = 'midori_attack3.mp3',
  --[CHAR_SOUND_HAHA_2] = 'silent.mp3',
  --[CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'midori_Clear.mp3', },
  [CHAR_SOUND_HOOHOO] = 'midori_attack3.mp3',
  [CHAR_SOUND_HRMM] = 'midori_yosh.mp3',
  [CHAR_SOUND_IMA_TIRED] = 'midori_hmm2.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'midori_letsgo.mp3',
  [CHAR_SOUND_MAMA_MIA] = 'midori_I lost.mp3',
  [CHAR_SOUND_ON_FIRE] = { 'midori_hurt1.mp3', },
  [CHAR_SOUND_OOOF] = 'midori_ah2.mp3',
  [CHAR_SOUND_OOOF2] = 'midori_hurt2.mp3',
  [CHAR_SOUND_PANTING] = { 'midori_pant.mp3', },
  --[CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  --[CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'midori_attack1.mp3', },
  [CHAR_SOUND_PUNCH_WAH] = 'midori_attack4.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'midori_attack7.mp3',
  --[CHAR_SOUND_SNORING1] = 'silent.mp3',
  --[CHAR_SOUND_SNORING2] = 'silent.mp3',
  --[CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'midori_attack2.mp3' },
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'midori_attack2.mp3' },
  [CHAR_SOUND_UH] = 'midori_wah.mp3',
  [CHAR_SOUND_UH2] = { 'midori_attack9.mp3', },
  [CHAR_SOUND_UH2_2] = 'midori_are.mp3',
  [CHAR_SOUND_WAAAOOOW] = 'midori_hurt1.mp3',
  [CHAR_SOUND_WAH2] = 'midori_attack4.mp3',
  [CHAR_SOUND_WHOA] = 'midori_huh.mp3',
  [CHAR_SOUND_YAHOO] = { 'midori_attack3a.mp3', },
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'midori_attack3.mp3', 'midori_attack2.mp3' },
  [CHAR_SOUND_YAH_WAH_HOO] = { 'midori_attack9.mp3', 'midori_attack6.mp3', 'midori_attack5.mp3' },
  --[CHAR_SOUND_YAWNING] = 'silent.mp3',
}

VT_YUZU = {
  [CHAR_SOUND_ATTACKED] = { 'yuzu_hurt3.mp3', 'yuzu_hurt4.mp3' },
  [CHAR_SOUND_DOH] = 'yuzu_surprise.mp3',   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'yuzu_dead.mp3' },
  [CHAR_SOUND_EEUH] = { 'yuzu_hngh.mp3', }, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'yuzu_tan.mp3' },
  [CHAR_SOUND_HAHA] = 'yuzu_letsgo.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'yuzu_starget.mp3', }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'yuzu_jump3.mp3',            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'yuzu_jump2.mp3',              -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'yuzu_phew.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'yuzu_letsgo.mp3',        -- Level Select
  --[CHAR_SOUND_MAMA_MIA] = 'silent.mp3', -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'yuzu_hurt1.mp3', },      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'yuzu_surprise.mp3',
  [CHAR_SOUND_OOOF2] = 'yuzu_hurt4.mp3',             -- Landing After a Bonk + Thrown out of level
  --[CHAR_SOUND_PANTING] = {'silent.mp3',}, -- Low Health
  --[CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  --[CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'yuzu_attack3.mp3', }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'yuzu_attack1.mp3',      --2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'yuzu_attack4.mp3',      -- 1st Punch
  --[CHAR_SOUND_SNORING1] = 'silent.mp3',
  --[CHAR_SOUND_SNORING2] = 'silent.mp3',
  --[CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'yuzu_hah.mp3' },                                       --Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'yuzu_jump2.mp3' },                                        -- Boing
  [CHAR_SOUND_UH] = 'yuzu_ah1.mp3',                                                        --Drop off of ledge
  [CHAR_SOUND_UH2] = { 'yuzu_tan.mp3', },                                                  -- ???
  [CHAR_SOUND_UH2_2] = 'yuzu_de.mp3',                                                      -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'silent.mp3',                                                    -- Falling
  [CHAR_SOUND_WAH2] = 'yuzu_tan.mp3',                                                      -- Throw Object
  [CHAR_SOUND_WHOA] = 'yuzu_ah1.mp3',                                                      -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'yuzu_attack3.mp3', },                                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'yuzu_hah.mp3', 'yuzu_attack3.mp3' },                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'yuzu_jump1.mp3', 'yuzu_attack6.mp3', 'yuzu_attack8.mp3' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = 'silent.mp3',
}

VT_ALICE = {
  [CHAR_SOUND_ATTACKED] = { 'alice_damage1.mp3', 'alice_damage2.mp3' },
  [CHAR_SOUND_DOH] = 'alice_are1.mp3',                                                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'alice_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'alice_yoisho2.mp3' },                                           -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'alice_ton.mp3' },
  [CHAR_SOUND_HAHA] = 'alice_laugh.mp3',                                                 -- Landing after backflip
  [CHAR_SOUND_HAHA_2] = 'alice_oho.mp3',                                                 -- Landing on Water after a fall
  [CHAR_SOUND_HERE_WE_GO] = { 'alice_panpakapan.mp3' },                                  -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'alice_jump4a.mp3',                                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'alice_pickup.mp3',                                                -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'alice_hmm1.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'alice_levelselect2.mp3',                                     -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'alice_wontlose.mp3',                                          -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'alice_damage3.mp3' },                                        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'alice_damage2.mp3',
  [CHAR_SOUND_OOOF2] = 'alice_damage1.mp3',                                              -- Landing After a Bonk + Thrown out of level
  [CHAR_SOUND_PUNCH_HOO] = { 'alice_attack2.mp3' },                                      -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'alice_attack3.mp3',                                          -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'alice_attack1.mp3',                                          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'alice_bowserthrow2.mp3' },                           -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'alice_oho.mp3' },                                       -- Boing
  [CHAR_SOUND_UH] = 'alice_ah1.mp3',                                                     -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'alice_kyu2.mp3' },                                               -- Quick Ledge Get-Up
  [CHAR_SOUND_UH2_2] = 'alice_to1.mp3',                                                  -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'alice_fall.mp3',                                              -- Falling
  [CHAR_SOUND_WAH2] = 'alice_attack2.mp3',                                               -- Throw Object
  [CHAR_SOUND_WHOA] = 'alice_eh1.mp3',                                                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'alice_attack6.mp3' },                                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'alice_attack7.mp3', 'alice_attack6.mp3' },         -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'alice_jump1.mp3', 'alice_jump2.mp3', 'alice_kyu1.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = 'alice_uu2.mp3'
}

VT_HIMARI = {
  --[CHAR_SOUND_ATTACKED] = {'kokona_dmg4.mp3', 'kokona_dmg1.mp3'},
  [CHAR_SOUND_DOH] = 'himari_ara2.mp3', -- Bonk into walls
  --[CHAR_SOUND_DYING] = {'kokona_dead1.mp3'},
  --[CHAR_SOUND_EEUH] = {'silent.mp3',}, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'himari_atk1.mp3' },
  [CHAR_SOUND_HAHA] = 'himari_laugh.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'himari_star.mp3', },  -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'himari_jump4.mp3',          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'himari_pickup.mp3',           -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = 'silent.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'himari_levelselect.mp3', -- Level Select
  --[CHAR_SOUND_MAMA_MIA] = 'kokona_daijobu.mp3', -- Getting up after thrown out of level
  --[CHAR_SOUND_ON_FIRE] = {'kokona_onfire.mp3',}, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'himari_eh1.mp3', -- Grabbed by Chuckya
  --[CHAR_SOUND_OOOF2] = 'kokona_dmg2.mp3', -- Landing After a Bonk + Thrown out of level
  --[CHAR_SOUND_PANTING] = {'silent.mp3',}, -- Low Health
  --[CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  --[CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'himari_atk5.mp3', }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'himari_atk4.mp3',      --2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'himari_atk7.mp3',      -- 1st Punch
  --[CHAR_SOUND_SNORING1] = 'silent.mp3',
  --[CHAR_SOUND_SNORING2] = 'silent.mp3',
  --[CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = 'himari_bowserthrow.mp3', --Bowser Throw
  --[CHAR_SOUND_TWIRL_BOUNCE] = {'silent.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'himari_huh1.mp3',                     --Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'himari_atk6.mp3', },               -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  --[CHAR_SOUND_WAAAOOOW] = 'silent.mp3', -- Falling
  [CHAR_SOUND_WAH2] = 'himari_atk2.mp3',                                                    -- Throw Object
  [CHAR_SOUND_WHOA] = 'himari_ara1.mp3',                                                    -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'himari_yo.mp3', },                                                -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'himari_yo.mp3', },                                    -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'himari_jump2.mp3', 'himari_jump3.mp3', 'himari_atk5.mp3' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = 'silent.mp3',
}

VT_YUUKA = {
  [CHAR_SOUND_ATTACKED] = { 'yuuka_dmg4.mp3', 'yuuka_dmg3.mp3' },
  [CHAR_SOUND_DOH] = { 'yuuka_hai.mp3', 'yuuka_are.mp3' }, -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'yuuka_dead1.mp3', 'yuuka_getup2.mp3' },
  -- [CHAR_SOUND_EEUH] = {nil,}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = nil, -- Game Over Voiceline
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'yuuka_atk2.mp3' },
  -- [CHAR_SOUND_HAHA] = nil, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = nil, -- Intro Voiceline
  [CHAR_SOUND_HERE_WE_GO] = { 'yuuka_starget1.mp3' },                  -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'yuuka_atk2.mp3',                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'yuuka_grab.mp3',                                -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'hina_sigh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'yuuka_levelselect.mp3' },                -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'yuuka_getup1.mp3', 'yuuka_notover.mp3' }, -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'yuuka_dmg3.mp3', 'yuuka_dmg4.mp3' },       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'yuuka_eh2.mp3',                                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'yuuka_dmg1.mp3',                               -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {nil,}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = nil,
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = nil,
  [CHAR_SOUND_PUNCH_HOO] = { 'yuuka_atk5.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'yuuka_atk2.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'yuuka_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = nil,
  -- [CHAR_SOUND_SNORING2] = nil,
  -- [CHAR_SOUND_SNORING3] = nil,
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'yuuka_useless.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = nil, -- Boing
  [CHAR_SOUND_UH] = 'yuuka_eh1.mp3',                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'yuuka_atk1.mp3' },                -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = nil, -- Falling
  [CHAR_SOUND_WAH2] = 'yuuka_atk4.mp3',                  -- Throw Object
  [CHAR_SOUND_WHOA] = 'yuuka_whoa.mp3',                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'yuuka_atk3.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'yuuka_atk4.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'yuuka_atk1.mp3' }        -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = nil,
}

VT_KOYUKI = {
  [CHAR_SOUND_ATTACKED] = { 'koyuki_dmg1.mp3', 'koyuki_dmg2.mp3', 'koyuki_dmg4.mp3', 'koyuki_dmg5.mp3' },
  [CHAR_SOUND_DOH] = 'koyuki_bonk.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'koyuki_dead.mp3' },
  -- [CHAR_SOUND_EEUH] = {'silent.mp3',}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'koyuki_groundpound.mp3' },
  [CHAR_SOUND_HAHA] = { 'koyuki_laugh1.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'koyuki_starget1.mp3', 'koyuki_starget2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'koyuki_jump4.mp3' },                               -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'koyuki_yes.mp3',                                       -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'koyuki_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'koyuki_ls1.mp3', 'koyuki_ls2.mp3' },            -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'koyuki_getup.mp3',                                 -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'koyuki_onfire.mp3' },                             -- Touch Fire
  [CHAR_SOUND_OOOF] = 'koyuki_note1.mp3',                                     -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'koyuki_bonk.mp3',                                     -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'koyuki_weak.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'koyuki_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'koyuki_atk2.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'koyuki_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'koyuki_bowserthrow1.mp3', 'koyuki_bowserthrow2.mp3', 'koyuki_bowserthrow1.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'silent.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'koyuki_surprise1.mp3',                                                                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'koyuki_atk1.mp3' },                                                                           -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'koyuki_falling.mp3',                                                                       -- Falling
  [CHAR_SOUND_WAH2] = 'koyuki_bang.mp3',                                                                              -- Throw Object
  [CHAR_SOUND_WHOA] = 'koyuki_ledgegrab.mp3',                                                                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'koyuki_longjump.mp3' },                                                                     -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'koyuki_jump1.mp3' },                                                            -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'koyuki_jump2.mp3', 'koyuki_jump3.mp3', 'koyuki_atk2.mp3' },                           -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'koyuki_yawn1.mp3' },
}

VT_HARE = {
  [CHAR_SOUND_ATTACKED] = { 'hare_dmg1.mp3', 'hare_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'hare_dmg1.mp3',
  [CHAR_SOUND_DYING] = { 'hare_dying.mp3', 'hare_gomen.mp3' },
  [CHAR_SOUND_EEUH] = 'hare_ledgeUp.mp3',
  [CHAR_SOUND_GAME_OVER] = 'hare_gomen.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = 'hare_jump2.mp3',
  [CHAR_SOUND_HAHA] = 'hare_un.mp3',
  [CHAR_SOUND_HAHA_2] = 'hare_un.mp3',
  [CHAR_SOUND_HERE_WE_GO] = 'hare_star.mp3',
  [CHAR_SOUND_HOOHOO] = 'hare_jump1.mp3',
  [CHAR_SOUND_HRMM] = 'hare_un.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'hare_letsGo.mp3', 'hare_compile.mp3' },
  [CHAR_SOUND_MAMA_MIA] = 'hare_levelFail.mp3',
  [CHAR_SOUND_ON_FIRE] = 'hare_burn.mp3',
  [CHAR_SOUND_HOOHOO] = 'hare_jump2.mp3',
  [CHAR_SOUND_OOOF] = 'hare_dmg1.mp3',
  [CHAR_SOUND_OOOF2] = 'hare_itata.mp3',
  [CHAR_SOUND_YAHOO] = 'hare_yahoo.mp3',
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hare_jump1.mp3', 'hare_jump1_1.mp3' },
  [CHAR_SOUND_PUNCH_HOO] = 'hare_yahoo.mp3',
  [CHAR_SOUND_PUNCH_WAH] = 'hare_punch2.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'hare_punch1.mp3',
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hare_tomate.mp3' },
  [CHAR_SOUND_UH] = 'hare_eh.mp3',
  [CHAR_SOUND_UH2] = 'hare_jump1.mp3',
  [CHAR_SOUND_UH2_2] = 'hare_oh.mp3',
  [CHAR_SOUND_WAAAOOOW] = 'hare_falling.mp3',
  [CHAR_SOUND_WHOA] = 'hare_ledgeGrab.mp3',
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hare_yahoo.mp3' },
  [CHAR_SOUND_IMA_TIRED] = 'hare_hmm2.mp3',
}

VT_NERU = {
  [CHAR_SOUND_ATTACKED] = { 'neru_dmg1.mp3', 'neru_dmg2.mp3' },
  [CHAR_SOUND_DYING] = 'neru_dying.mp3',
  [CHAR_SOUND_DOH] = 'neru_dmg2.mp3',
  [CHAR_SOUND_PUNCH_HOO] = 'neru_kick.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = 'neru_groundPound.mp3',
  [CHAR_SOUND_HAHA] = 'neru_laugh.mp3',
  [CHAR_SOUND_HAHA_2] = 'neru_laugh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'neru_letsGo.mp3', 'neru_letsGo2.mp3' },
  [CHAR_SOUND_HOOHOO] = { 'neru_jump2.mp3', 'neru_jump2_2.mp3' },
  [CHAR_SOUND_YAHOO] = 'neru_kick.mp3',
  [CHAR_SOUND_MAMA_MIA] = { 'neru_levelFail.mp3', 'neru_levelFail2.mp3' },
  [CHAR_SOUND_HRMM] = 'neru_grab.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'neru_star.mp3', 'neru_star2.mp3' },
  [CHAR_SOUND_UH] = 'neru_eh.mp3',
  [CHAR_SOUND_OOOF] = 'neru_dmg1.mp3',
  [CHAR_SOUND_YAH_WAH_HOO] = { 'neru_punch1.mp3' },
  [CHAR_SOUND_OOOF2] = 'neru_dmg1.mp3',
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = 'neru_jump3.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'neru_punch1.mp3',
  [CHAR_SOUND_PUNCH_WAH] = 'neru_punch2.mp3',
  [CHAR_SOUND_WAAAOOOW] = 'neru_falling.mp3',
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'neru_bowser.mp3' },
  [CHAR_SOUND_WHOA] = 'neru_ledgeGrab.mp3',
  [CHAR_SOUND_ON_FIRE] = 'neru_falling.mp3',
  [CHAR_SOUND_IMA_TIRED] = 'neru_sleepy.mp3',
}

VT_TOKI = {
  [CHAR_SOUND_ATTACKED] = { 'toki_dmg1.mp3', 'toki_dmg2.mp3', 'toki_dmg3.mp3' },
  [CHAR_SOUND_DYING] = 'toki_dying.mp3',
  [CHAR_SOUND_DOH] = 'toki_dmg1.mp3',
  [CHAR_SOUND_PUNCH_HOO] = 'toki_kick.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = 'toki_groundPound.mp3',
  [CHAR_SOUND_HAHA] = 'toki_pyon.mp3',
  [CHAR_SOUND_HAHA_2] = 'toki_pyon.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'toki_letsGo.mp3' },
  [CHAR_SOUND_HOOHOO] = { 'toki_jump2.mp3' },
  [CHAR_SOUND_YAHOO] = 'toki_longjump.mp3',
  [CHAR_SOUND_MAMA_MIA] = { 'toki_levelFail.mp3' },
  [CHAR_SOUND_HRMM] = 'toki_grab.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'toki_star.mp3', 'toki_star2.mp3' },
  [CHAR_SOUND_UH] = 'toki_ah.mp3',
  [CHAR_SOUND_OOOF] = 'toki_dmg2.mp3',
  [CHAR_SOUND_YAH_WAH_HOO] = { 'toki_jump1.mp3' },
  [CHAR_SOUND_OOOF2] = 'toki_dmg2.mp3',
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = 'toki_yahoo.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'toki_punch1.mp3',
  [CHAR_SOUND_PUNCH_WAH] = 'toki_punch2.mp3',
  [CHAR_SOUND_WAAAOOOW] = 'toki_falling.mp3',
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'toki_bowser.mp3' },
  [CHAR_SOUND_WHOA] = 'toki_ledgeGrab.mp3',
  [CHAR_SOUND_ON_FIRE] = 'toki_falling.mp3',
  [CHAR_SOUND_IMA_TIRED] = 'toki_sleepy.mp3',
}

VT_HIBIKI = {
  [CHAR_SOUND_ATTACKED] = { 'hibiki_dmg1.mp3', 'hibiki_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'hibiki_huh.mp3',                                     -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'hibiki_dying.mp3' },
  [CHAR_SOUND_EEUH] = { 'hibiki_ledgeUp.mp3' },                            -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'hibiki_groundPound.mp3' },
  [CHAR_SOUND_HAHA] = { 'hibiki_hmm.mp3' },                                -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'hibiki_star.mp3' },                         -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'hibiki_jump2.mp3' },                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'hibiki_hmm.mp3',                                    -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'srk_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'hibiki_letsGo.mp3' },                        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'hibiki_levelFail.mp3' },                      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'hibiki_falling.mp3' },                         -- Touch Fire
  [CHAR_SOUND_OOOF] = 'hibiki_huh.mp3',                                    -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'hibiki_dmg3.mp3',                                  -- Landing After a Bonk + Thrown out of level
  [CHAR_SOUND_PUNCH_HOO] = { 'hibiki_kick.mp3' },                          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'hibiki_punch2.mp3',                            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'hibiki_punch1.mp3',                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hibiki_bowser.mp3' },                  -- Bowser Throw
  [CHAR_SOUND_UH] = 'hibiki_huh.mp3',                                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'hibiki_falling.mp3',                            -- Falling
  [CHAR_SOUND_WHOA] = 'hibiki_huh.mp3',                                    -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'hibiki_iko.mp3' },                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hibiki_kick.mp3' },                  -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hibiki_jump1.mp3', 'hibiki_jump1_1.mp3' }, -- 1st Jump(s)
}

VT_NOA = {
  [CHAR_SOUND_ATTACKED] = { 'noa_dmg2.mp3', 'noa_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'noa_ara.mp3',             -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'noa_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'noa_laugh.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'noa_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'noa_jump2.mp3' },    -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'noa_grab.mp3',           -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'noa_sleepy.mp3',
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'noa_atk6.mp3'},
  [CHAR_SOUND_LETS_A_GO] = { 'noa_letsGo.mp3' },                                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'noa_levelFail.mp3' },                                    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'noa_falling.mp3' },                                       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'noa_ara.mp3',                                                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'noa_dmg1.mp3',                                                -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'noa_kick.mp3' },                                        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'noa_punch2.mp3',                                          -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'noa_punch1.mp3',                                          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'noa_bowser.mp3' },                                -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                               -- Boing
  [CHAR_SOUND_UH] = 'noa_ara.mp3',                                                    -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'noa_atk4.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'noa_falling.mp3',                                          -- Falling
  -- [CHAR_SOUND_WAH2] = {'noa_throw1.mp3'},-- Throw Object
  [CHAR_SOUND_WHOA] = 'noa_grab.mp3',                                                 -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'noa_kick.mp3' },                                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'noa_yahoo.mp3' },                               -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'noa_jump1.mp3', 'noa_punch2.mp3', 'noa_punch1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'noa_yawn.mp3'},
}

VT_RIO = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_smrpg_hit1.mp3', 'sfx_smrpg_shell.mp3', 'sfx_smw_bossstun.mp3' },
  [CHAR_SOUND_DOH] = 'sfx_ml_bump.mp3',                                          -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sfx_smb3_down.mp3' },
  [CHAR_SOUND_HERE_WE_GO] = { 'rio_star1.mp3' },                                 -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'rio_ls1.mp3' },                                    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'rio_levelexit.mp3' },                               -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                  -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'rio_atk5.mp3' },                                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                -- Touch Fire
  [CHAR_SOUND_OOOF] = 'rio_what.mp3',                                            -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_drop.mp3',                                     -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sfx_ssb64_atk3.mp3' },                             -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'rio_atk4.mp3',                                       -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'rio_atk1.mp3',                                       -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'rio_bthrow1.mp3' },                          -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'rio_denied.mp3' },                                      -- Throw Object
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                       -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                               -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                          -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                                     -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sfx_ssb64_superjump.mp3' },                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sfx_ssb64_superjump.mp3' },                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'rio_atk1.mp3', 'rio_atk3.mp3', 'rio_atk6.mp3' }, -- 1st Jump(s)
}

VT_SUMIRE = {
  [CHAR_SOUND_ATTACKED] = { 'sumire_dmg2.mp3', 'sumire_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'sumire_are.mp3',                                  -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sumire_dead1.mp3', 'sumire_dead2.mp3' },
  [CHAR_SOUND_HAHA] = { 'sumire_laugh.mp3' },                           -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'sumire_star1.mp3', 'sumire_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'sumire_jump2.mp3' },                         -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sumire_grab.mp3',                                -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'sumire_sleepy.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'sumire_yahoo2.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'sumire_letsGo.mp3' },                                           -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'sumire_levelFail.mp3' },                                         -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sumire_dmg2.mp3' },                                               -- Touch Fire
  [CHAR_SOUND_OOOF] = 'sumire_are.mp3',                                                       -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sumire_dmg1.mp3',                                                     -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sumire_kick.mp3' },                                             -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sumire_punch2.mp3',                                               -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sumire_punch1.mp3',                                               -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sumire_bowser.mp3' },                                     -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                       -- Boing
  [CHAR_SOUND_UH] = 'sumire_are.mp3',                                                         -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'sumire_punch1.mp3' },                                                 -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'sumire_falling.mp3',                                               -- Falling
  -- [CHAR_SOUND_WAH2] = {'sumire_throw1.mp3'},-- Throw Object
  [CHAR_SOUND_WHOA] = 'sumire_grab.mp3',                                                      -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sumire_yahoo1.mp3', 'sumire_yahoo2.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sumire_jump3.mp3' },                                    -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sumire_jump4.mp3', 'sumire_punch1.mp3', 'sumire_jump1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'sumire_yawn.mp3'},
}

VT_EIMI = {
  [CHAR_SOUND_ATTACKED] = { 'eimi_dmg1.mp3', 'eimi_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'eimi_huh1.mp3',                                               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'eimi_defeat1.mp3', 'eimi_defeat2.mp3' },
  [CHAR_SOUND_HERE_WE_GO] = { 'eimi_star1.mp3' },                                   -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'eimi_ls1.mp3' },                                      -- Level Select
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                     -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'eimi_sleepy.mp3',
  [CHAR_SOUND_HOOHOO] = { 'eimi_atk2.mp3' },                                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'eimi_dmg3.mp3' },                                       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'eimi_hmmm1.mp3',                                             -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'eimi_dmg1.mp3',                                             -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'eimi_atk5.mp3' },                                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'eimi_atk2.mp3',                                         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'eimi_atk1.mp3',                                         -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'eimi_bthrow1.mp3' },                            -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'eimi_throw1.mp3' },                                        -- Throw Object
  [CHAR_SOUND_UH] = 'eimi_hmmm3.mp3',                                               -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'eimi_hmmm2.mp3',                                         -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                             -- Boing
  [CHAR_SOUND_HAHA] = { 'eimi_haha.mp3' },                                         -- Landing after backflip
  [CHAR_SOUND_WHOA] = 'eimi_huh1.mp3',                                              -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'eimi_longjump.mp3' },                                     -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'eimi_triplejump.mp3' },                       -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'eimi_atk4.mp3', 'eimi_atk5.mp3', 'eimi_atk3.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'eimi_sigh.mp3' },
}

VT_ASUNA = {
  [CHAR_SOUND_ATTACKED] = { 'asuna_dmg2.mp3', 'asuna_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'asuna_ooh.mp3',             -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'asuna_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'asuna_jaan.mp3' },       -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'asuna_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'asuna_punch1.mp3' },   -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'asuna_grab.mp3',           -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'asuna_sleepy.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'asuna_kick.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'asuna_letsGo.mp3' },        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'asuna_levelFail.mp3' },      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'asuna_dmg2.mp3' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'asuna_grab.mp3',                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'asuna_dmg2.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'asuna_kick.mp3' },          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'asuna_punch2.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'asuna_punch1.mp3',            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'asuna_bowser.mp3' },  -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },   -- Boing
  -- [CHAR_SOUND_UH] = 'asuna_are.mp3', -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'asuna_punch1.mp3' },              -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'asuna_falling.mp3',            -- Falling
  -- [CHAR_SOUND_WAH2] = {'asuna_throw1.mp3'},-- Throw Object
  [CHAR_SOUND_WHOA] = 'asuna_grab.mp3',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'asuna_yahoo.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'asuna_yahoo.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'asuna_punch2.mp3' },      -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'sumire_yawn.mp3'},
}

VT_KARIN = {
  [CHAR_SOUND_ATTACKED] = { 'karin_dmg2.mp3', 'karin_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'karin_ugh.mp3',             -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'karin_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'karin_un.mp3' },         -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'karin_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'karin_jump2.mp3' },    -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'karin_grab.mp3',           -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'karin_sleepy.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'karin_yahoo.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'karin_letsGo.mp3' },                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'karin_levelFail.mp3' },                    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'karin_dmg2.mp3' },                          -- Touch Fire
  [CHAR_SOUND_OOOF] = 'karin_ugh.mp3',                                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'karin_dmg1.mp3',                                -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'karin_kick.mp3' },                        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'karin_punch2.mp3',                          -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'karin_punch1.mp3',                          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'karin_bowser.mp3' },                -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                 -- Boing
  -- [CHAR_SOUND_UH] = 'karin_are.mp3', 								-- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'karin_punch1.mp3' },                            -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'karin_ugh.mp3',                              -- Falling
  -- [CHAR_SOUND_WAH2] = {'karin_throw1.mp3'},							-- Throw Object
  [CHAR_SOUND_WHOA] = 'karin_grab.mp3',                                 -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'karin_yahoo.mp3' },                           -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'karin_yahoo.mp3' },               -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'karin_punch1.mp3', 'karin_jump1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'karin_yawn.mp3'},
}

VT_AKANE = {
  [CHAR_SOUND_ATTACKED] = { 'akane_dmg2.mp3', 'akane_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'akane_ara.mp3',             -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'akane_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'akane_laugh.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'akane_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'akane_jump2.mp3' },    -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'akane_ara.mp3',            -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'akane_sleepy.mp3',
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'akane_yahoo2.mp3'},
  [CHAR_SOUND_LETS_A_GO] = { 'akane_letsGo.mp3' },                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'akane_levelFail.mp3' },                    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'akane_dmg2.mp3' },                          -- Touch Fire
  [CHAR_SOUND_OOOF] = 'akane_ara.mp3',                                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'akane_dmg1.mp3',                                -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'akane_kick.mp3' },                        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'akane_jump2.mp3',                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'akane_punch1.mp3',                          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'akane_bowser.mp3' },                -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                 -- Boing
  [CHAR_SOUND_UH] = 'akane_ara.mp3',                                    -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'akane_punch1.mp3' },                            -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'akane_falling.mp3',                          -- Falling
  -- [CHAR_SOUND_WAH2] = {'akane_throw1.mp3'},-- Throw Object
  [CHAR_SOUND_WHOA] = 'akane_ara.mp3',                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'akane_yahoo.mp3' },                           -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'akane_yahoo.mp3' },               -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'akane_jump1.mp3', 'akane_punch1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'akane_yawn.mp3'},
}

VT_MAKI = {
  [CHAR_SOUND_ATTACKED] = { 'maki_dmg1.mp3' },
  [CHAR_SOUND_DYING] = 'maki_dying.mp3',
  [CHAR_SOUND_DOH] = 'maki_dmg1.mp3',
  [CHAR_SOUND_PUNCH_HOO] = 'maki_kick.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = 'maki_kick.mp3',
  [CHAR_SOUND_HAHA] = 'maki_laugh.mp3',
  [CHAR_SOUND_HAHA_2] = 'maki_laugh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'maki_letsGo.mp3' },
  [CHAR_SOUND_HOOHOO] = { 'maki_jump2.mp3' },
  [CHAR_SOUND_YAHOO] = 'maki_yahoo.mp3',
  [CHAR_SOUND_MAMA_MIA] = { 'maki_levelFail.mp3' },
  [CHAR_SOUND_HRMM] = 'maki_grab.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'maki_star.mp3' },
  [CHAR_SOUND_UH] = 'maki_ueh.mp3',
  [CHAR_SOUND_OOOF] = 'maki_ueh.mp3',
  [CHAR_SOUND_YAH_WAH_HOO] = { 'maki_jump1.mp3' },
  [CHAR_SOUND_OOOF2] = 'maki_ueh.mp3',
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = 'maki_jump3.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'maki_jump1.mp3',
  [CHAR_SOUND_PUNCH_WAH] = 'maki_punch2.mp3',
  [CHAR_SOUND_WAAAOOOW] = 'maki_falling.mp3',
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'maki_bowser.mp3', 'maki_bowser2.mp3' },
  [CHAR_SOUND_WHOA] = 'maki_ledgeGrab.mp3',
  [CHAR_SOUND_ON_FIRE] = 'maki_falling.mp3',
}

VT_CHIHIRO = {
  [CHAR_SOUND_ATTACKED] = { 'chihiro_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'chihiro_eh.mp3',                            -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'chihiro_dead1.mp3' },
  [CHAR_SOUND_HAHA] = 'chihiro_laugh.mp3',                        -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'chihiro_star1.mp3' },              -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'chihiro_levelselect.mp3' },         -- Level Select
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                   -- Object Pick-up
  [CHAR_SOUND_MAMA_MIA] = 'chihiro_levelexit.mp3',                -- Getting up after thrown out of level --
  [CHAR_SOUND_HOOHOO] = { 'chihiro_atk2.mp3' },                   -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                 -- Touch Fire
  [CHAR_SOUND_OOOF] = 'chihiro_huh2.mp3',                         -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'chihiro_dmg1.mp3',                        -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'chihiro_atk2.mp3' },                -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'chihiro_atk3.mp3',                    -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'chihiro_atk1.mp3',                    -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'chihiro_boom.mp3' },          -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'sfx_ssb64_itemthrow.mp3' },              -- Throw Object
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                        -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },           -- Boing
  [CHAR_SOUND_WHOA] = 'chihiro_huh.mp3',                          -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sfx_ssb64_superjump.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sfx_ssb64_superjump.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'chihiro_atk3.mp3' },              -- 1st Jump(s)
}

VT_KOTAMA = {
  [CHAR_SOUND_ATTACKED] = { 'kotama_dmg1.mp3', 'kotama_dmg2.mp3' }, --
  [CHAR_SOUND_DOH] = 'kotama_eh.mp3',                               -- Bonk into walls
  [CHAR_SOUND_DYING] = 'kotama_dying.mp3',
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'kotama_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'kotama_laugh.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = 'kotama_star.mp3',                           -- Star Get + Obtaining Power-up --
  [CHAR_SOUND_HOOHOO] = 'kotama_jump2.mp3',                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                          -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = { 'kotama_tired.mp3' },
  [CHAR_SOUND_LETS_A_GO] = 'kotama_letsGo.mp3',                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'kotama_levelFail.mp3',                        -- Getting up after thrown out of level --
  [CHAR_SOUND_ON_FIRE] = { 'kotama_burn.mp3' },                          -- Touch Fire --
  [CHAR_SOUND_OOOF] = 'kotama_dmg2.mp3',
  [CHAR_SOUND_OOOF2] = 'kotama_dmg1.mp3',                                -- Landing After a Bonk + Thrown out of level --
  [CHAR_SOUND_PUNCH_HOO] = { 'kotama_kick.mp3' },                        -- Kick --
  [CHAR_SOUND_PUNCH_WAH] = 'kotama_punch1.mp3',                          -- 2nd Punch --
  [CHAR_SOUND_PUNCH_YAH] = 'kotama_punch1.mp3',                          -- 1st Punch --
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'kotama_bowser.mp3' },                -- Bowser Throw --
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                  -- Boing
  [CHAR_SOUND_UH] = 'kotama_eh.mp3',                                     -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'kotama_jump2.mp3' },                             -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'kotama_burn.mp3',                             -- Falling
  -- [CHAR_SOUND_WAH2] = 'sfx_ssb64_itemthrow.mp3',          -- Throw Object --
  [CHAR_SOUND_WHOA] = 'kotama_grab.mp3',                                 -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kotama_yahoo.mp3' },                           -- Long Jump --
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'kotama_yahoo.mp3' },               -- 3rd Jump(s) --
  [CHAR_SOUND_YAH_WAH_HOO] = { 'kotama_jump1.mp3', 'kotama_jump3.mp3' }, -- 1st Jump(s) --
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_UTAHA = {
  [CHAR_SOUND_ATTACKED] = { 'utaha_dmg1.mp3', 'utaha_dmg2.mp3', 'utaha_dmg3.mp3' }, --
  -- [CHAR_SOUND_DOH] = 'utaha_surprised2.mp3',                                               -- Bonk into walls
  [CHAR_SOUND_DYING] = 'utaha_dying.mp3',
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'utaha_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'utaha_laugh.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = 'utaha_star.mp3',     -- Star Get + Obtaining Power-up --
  [CHAR_SOUND_HOOHOO] = 'utaha_jump2.mp3',        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',   -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = { 'utaha_tired.mp3' },
  [CHAR_SOUND_LETS_A_GO] = 'utaha_letsGo.mp3',    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'utaha_levelFail.mp3',  -- Getting up after thrown out of level --
  [CHAR_SOUND_ON_FIRE] = { 'utaha_dmg2.mp3' },    -- Touch Fire --
  -- [CHAR_SOUND_OOOF] = 'utaha_wah.mp3',
  [CHAR_SOUND_OOOF2] = 'utaha_dmg1.mp3',          -- Landing After a Bonk + Thrown out of level --
  [CHAR_SOUND_PUNCH_HOO] = { 'utaha_jump4.mp3' }, -- Kick --
  -- [CHAR_SOUND_PUNCH_WAH] = 'utaha_atk1.mp3',             -- 2nd Punch --
  -- [CHAR_SOUND_PUNCH_YAH] = 'utaha_atk1.mp3',             -- 1st Punch --
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'utaha_star.mp3' },  -- Bowser Throw --
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },  -- Boing
  -- [CHAR_SOUND_UH] = 'utaha_wah.mp3',                     -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'utaha_jump1.mp3' },              -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = 'utaha_fall.mp3',              -- Falling
  [CHAR_SOUND_WAH2] = 'sfx_ssb64_itemthrow.mp3', -- Throw Object --
  -- [CHAR_SOUND_WHOA] = 'utaha_huh.mp3',                   -- Ledge Grab
  -- [CHAR_SOUND_YAHOO] = { 'utaha_longjump.mp3' },         -- Long Jump --
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'utaha_jump3.mp3' }, -- 3rd Jump(s) --
  [CHAR_SOUND_YAH_WAH_HOO] = { 'utaha_jump1.mp3' },       -- 1st Jump(s) --
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_KOTORI = {
  [CHAR_SOUND_ATTACKED] = { 'kotori_dmg1.mp3', 'kotori_dmg2.mp3' }, --
  [CHAR_SOUND_DOH] = 'kotori_eh.mp3',                               -- Bonk into walls
  [CHAR_SOUND_DYING] = 'kotori_dying.mp3',
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'kotori_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'kotori_hurray.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = 'kotori_star.mp3',          -- Star Get + Obtaining Power-up --
  [CHAR_SOUND_HOOHOO] = 'kotori_jump1.mp3',             -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'kotori_grab.mp3',                -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = { 'kotori_tired.mp3' },
  [CHAR_SOUND_LETS_A_GO] = 'kotori_letsGo.mp3',         -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'kotori_levelFail.mp3',       -- Getting up after thrown out of level --
  [CHAR_SOUND_ON_FIRE] = 'kotori_burn.mp3',             -- Touch Fire --
  [CHAR_SOUND_OOOF] = 'kotori_dmg2.mp3',
  [CHAR_SOUND_OOOF2] = 'kotori_dmg1.mp3',               -- Landing After a Bonk + Thrown out of level --
  [CHAR_SOUND_PUNCH_HOO] = { 'kotori_kick.mp3' },       -- Kick --
  [CHAR_SOUND_PUNCH_WAH] = 'kotori_punch2.mp3',         -- 2nd Punch --
  [CHAR_SOUND_PUNCH_YAH] = 'kotori_punch1.mp3',         -- 1st Punch --
  -- [CHAR_SOUND_SO_LONGA_BOWSER] = { 'kotori_bthrow.mp3' }, -- Bowser Throw --
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' }, -- Boing
  [CHAR_SOUND_UH] = 'kotori_eh.mp3',                    -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'kotori_jump1.mp3' },            -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'kotori_falling.mp3',         -- Falling
  [CHAR_SOUND_WAH2] = 'sfx_ssb64_itemthrow.mp3',        -- Throw Object --
  [CHAR_SOUND_WHOA] = 'kotori_grab.mp3',                -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kotori_yahoo.mp3' },          -- Long Jump --
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = 'kotori_yahoo.mp3',  -- 3rd Jump(s) --
  [CHAR_SOUND_YAH_WAH_HOO] = { 'kotori_jump2.mp3' },    -- 1st Jump(s) --
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_REI = {
  [CHAR_SOUND_ATTACKED] = { 'rei_dmg1.mp3', 'rei_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'rei_eh.mp3',                                -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'rei_dead1.mp3', 'rei_dead2.mp3' },
  [CHAR_SOUND_HAHA] = { 'rei_hehe.mp3' },                         -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'rei_star2.mp3', 'rei_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'rei_levelstart.mp3' },              -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'rei_levelexit.mp3' },                -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                   -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'rei_atk3.mp3' },                       -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'rei_burn.mp3' },                      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'rei_eh.mp3',                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'rei_dmg1.mp3',                            -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'rei_atk1.mp3' },                    -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'rei_atk4.mp3',                        -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'rei_atk2.mp3',                        -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'rei_homerun.mp3' },           -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'rei_atk1.mp3' },                         -- Throw Object
  [CHAR_SOUND_UH] = 'rei_uwa.mp3',                                -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'rei_atk2.mp3' },                          -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'rei_burn.mp3',                         -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },           -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                      -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'rei_longjump.mp3' },                    -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'rei_longjump.mp3' },        -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'rei_atk2.mp3' },                  -- 1st Jump(s)
  [CHAR_SOUND_EEUH] = { 'rei_ledgeclimb.mp3' },                   -- Slow climb from ledge
}
